;;;   Programm:      ACM-MVERSETZEN.LSP
;;;   Befehlsaufruf: ACM-MVERSETZEN
;;;   Funktion:      Objekte mehrfach versetzen
;;;   Autor:         Gerhard Rampf
;;;                  Kundenspezifische Anpassungen fr AutoCAD und ZWCAD
;;;                  Liebigstr. 3 A
;;;                  86399 Bobingen
;;;                  E-Mail: rampf@geracad.de
;;;   Datum:         19.08.2023
;;;   Plattform:     Alle AutoCAD-Versionen ab Version 2005
(defun c:acm-mversetzen ( / mvs115 mvs116 svm001 svm002 svm003 svm004 svm005 svm006 svm007 svm008 svm009 svm010 svm011 svm012 svm013 svm014 svm015 svm016 svm017 svm018 svm019 svm020 svm021 svm022 svm023 svm024 svm025 svm026 svm027)
    (defun svm001 (mvs001 mvs002 / mvs029 mvs026 mvs027 mvs028)
      (setq mvs026 (strlen mvs001))
        (if (> mvs026 mvs002)
          (progn
            (setq mvs027 (substr mvs001 1 (/ (- mvs002 3) 2)))
            (setq mvs028 (substr mvs001 (- mvs026 (1- (/ (- mvs002 3) 2)))))
            (setq mvs029 (strcat mvs027 "\056\056\056" mvs028))
          )
        )
        (if mvs029
          mvs029
          mvs001
        )
    )
    (defun svm002 ( / mvs030 mvs031 mvs032 mvs033 mvs034 mvs035 mvs036 mvs037 mvs038 mvs039 mvs040 mvs041 mvs042 mvs043 mvs044 mvs045 mvs046 mvs047 mvs048)
      (sssetfirst nil nil)
      (setq mvs030 (getvar "CMDECHO"))
      (svm011 "CMDECHO" 0)
      (setq mvs031 (getvar "OFFSETDIST"))
        (if
          (and
            (setq mvs032 (svm019))
            (setq mvs033 (svm014))
            (setq mvs034 (svm012))
            (setq mvs035 (svm003 (cdr (assoc 8 (entget mvs034)))))
            (car mvs035)
          )
            (progn
              (if
                (and
                  (setq mvs036 (cadr mvs035))
                  (= (car mvs036) 1)
                )
                  (progn
                    (setq mvs037 1)
                    (setq mvs038 (cadr mvs036))
                      (if (= (vla-get-Lock (setq mvs039 (vlax-ename->vla-object (tblobjname "LAYER" mvs038)))) :vlax-true)
                        (progn
                          (setq mvs040 1)
                          (vla-put-Lock mvs039 :vlax-false)
                        )
                        (setq mvs040 0)
                      )
                    (setq mvs041 (vlax-ename->vla-object mvs034))
                    (setq mvs042 (vla-get-Layer mvs041))
                    (vla-put-Layer mvs041 mvs038)
                  )
                  (setq mvs037 0)
              )
              (if (setq mvs043 (svm004 mvs034 mvs032 (car mvs035)))
                (progn
                  (setq mvs044 (vlax-ename->vla-object mvs034))
                  (setq mvs045 1)
                  (setq mvs046 1)
                  (setq mvs047 1)
                    (while (< mvs046 mvs033)
                      (setq mvs048 (vl-catch-all-apply 'vla-Offset (list mvs044 (* (setq mvs045 (1+ mvs045)) mvs043))))
                        (if (/= (type mvs048) 'VL-CATCH-ALL-APPLY-ERROR)
                          (progn
                            (setq mvs047 (1+ mvs047))
                            (setq mvs046 (1+ mvs046))
                          )
                          (setq mvs046 mvs033)
                        )
                    )
                    (if (= mvs037 1)
                      (vla-put-Layer mvs041 mvs042)
                    )
                    (if (= mvs040 1)
                      (vla-put-Lock mvs039 :vlax-true)
                    )
                )
              )
            )
        )
        (if (= (type mvs034) 'ENAME)
          (vl-catch-all-apply 'redraw (list mvs034 4))
        )
      (svm011 "OFFSETDIST" mvs031)
      (svm011 "CMDECHO" mvs030)
        (if (= (type mvs047) 'INT)
          (progn
            (if (< mvs047 mvs033)
              (progn
                (if (= mvs047 1)
                  (prompt "\nACHTUNG: Es konnte nur 1 Versatzvorgang ausgefhrt werden. ")
                  (prompt (strcat "\nACHTUNG: Es konnten nur " (itoa mvs047) " Versatzvorgnge ausgefhrt werden. "))
                )
              )
            )
          )
        )
    )
    (defun svm003 (mvs003 / mvs035 mvs049)
      (setq mvs035 "Layer")
        (while (= mvs035 "Layer")
          (initget "Layer")
          (setq mvs035 (getpoint "\nPunkt auf Seite angeben, auf die versetzt werden soll oder [Layer]: "))
            (if (= mvs035 "Layer")
              (setq mvs049 (svm024 mvs003))
            )
        )
        (if mvs049
          (list mvs035 mvs049)
          (list mvs035)
        )
    )
    (defun svm004 (mvs004 mvs005 mvs006 /  mvs050 mvs051 mvs052 mvs053 mvs054 mvs055 mvs056 mvs057 mvs058 mvs059 mvs060)
      (setq mvs050 (vlax-ename->vla-object mvs004))
      (setq mvs051 (strcase (vla-get-ObjectName mvs050)))
      (setq mvs052 (entlast))
      (vl-cmdf "._offset" mvs005 mvs004 mvs006 "")
        (if (svm006 mvs052)
          (progn
              (while (setq mvs053 (entnext mvs052))
                 (setq mvs052 mvs053)
                 (setq mvs054 (vlax-ename->vla-object mvs053))
                 (setq mvs055 (strcase (vla-get-ObjectName mvs054)))
                   (if
                     (and
                       (not (vl-string-search "SEQ" mvs055))
                       (not (vl-string-search "VERT" mvs055))
                     )
                       (setq mvs056 (cons mvs054 mvs056))
                   )
              )
            (setq mvs057 (vl-catch-all-apply 'vla-Offset (list mvs050 mvs005)))
              (if (/= (type mvs057) 'VL-CATCH-ALL-APPLY-ERROR)
                (progn
                  (setq mvs058 (vlax-safearray->list (vlax-variant-value mvs057)))
                  (setq mvs059 (car mvs056))
                  (setq mvs060 (svm005 mvs059 mvs058))
                    (if (= mvs060 0)
                      (setq mvs005 (- mvs005))
                    )
                    (while mvs058
                      (vl-catch-all-apply 'vla-Delete (list (car mvs058)))
                      (setq mvs058 (cdr mvs058))
                    )
                )
                (setq mvs005 (- mvs005))
              )
          )
          (setq mvs005 nil)
        )
      mvs005
    )
    (defun svm005 (mvs004 mvs007 / mvs061 mvs062 mvs063 mvs064 mvs065 mvs066 mvs200 mvs201 mvs202 mvs203)
      (setq mvs061 0)
      (vla-GetBoundingBox mvs004 'mvs200 'mvs201)
      (setq mvs062 (vlax-safearray->list mvs200))
      (setq mvs063 (vlax-safearray->list mvs201))
        (while mvs007
          (setq mvs064 (car mvs007))
          (vla-GetBoundingBox mvs064 'mvs202 'mvs203)
          (setq mvs065 (vlax-safearray->list mvs202))
          (setq mvs066 (vlax-safearray->list mvs203))
            (if
              (and
                (equal (distance mvs062 mvs065) 0.0 0.001)
                (equal (distance mvs063 mvs066) 0.0 0.001)
              )
                (progn
                  (setq mvs061 1)
                  (setq mvs007 nil)
                )
            )
          (setq mvs007 (cdr mvs007))
        )
      mvs061
    )
    (defun svm006 (mvs008 / mvs053 mvs054 mvs055 mvs067)
        (while
          (and
            (setq mvs053 (entnext mvs008))
            (not mvs067)
          )
            (setq mvs008 mvs053)
            (setq mvs054 (vlax-ename->vla-object mvs053))
            (setq mvs055 (strcase (vla-get-ObjectName mvs054)))
              (if
                (and
                  (not (vl-string-search "SEQ" mvs055))
                  (not (vl-string-search "VERT" mvs055))
                )
                  (setq mvs067 mvs053)
              )
        )
      mvs067
    )
    (defun svm007 (mvs004 / mvs068 mvs069)
      (setq mvs068 (strcase (cdr (assoc 0 (entget mvs004)))))
        (if (vl-position mvs068 '("ARC" "CIRCLE" "ELLIPSE" "LINE" "LWPOLYLINE" "POLYLINE" "SPLINE"))
          (progn
            (if (> (svm008 mvs004) 0.0)
              (setq mvs069 T)
              (progn
                (setq mvs069 nil)
                (princ "\nDieses Objekt kann nicht versetzt werden. ")
              )
            )
          )
          (setq mvs069 T)
        )
      mvs069
    )
    (defun svm008 (mvs004 / mvs070 mvs071)
      (vl-load-com)
        (if (= (type mvs004) 'LIST)
          (setq mvs070 (car mvs004))
          (setq mvs070 mvs004)
        )
        (if
          (and
            (setq mvs071 (vla-get-ObjectName (vlax-ename->vla-object mvs070)))
            (vl-position (strcase mvs071) (list "ACDB2DPOLYLINE" "ACDB3DPOLYLINE" "ACDBARC" "ACDBCIRCLE" "ACDBELLIPSE" "ACDBHELIX" "ACDBLINE" "ACDBPOLYLINE" "ACDBSPLINE"))
          )
            (vlax-curve-getDistAtParam mvs070 (vlax-curve-getEndParam mvs070))
            1.0
        )
    )
    (defun svm009 (mvs009 mvs010 / mvs072 mvs073 mvs074 mvs075 mvs076 mvs077 mvs078)
      (setq mvs072 mvs009)
      (setq mvs073 mvs010)
        (repeat (length mvs072)
          (setq mvs074 (cons (strcase (car mvs072)) mvs074))
          (setq mvs072 (cdr mvs072))
        )
        (repeat (length mvs073)
          (setq mvs075 (cons (strcase (car mvs073)) mvs075))
          (setq mvs073 (cdr mvs073))
        )
      (setq mvs074 (reverse mvs074))
      (setq mvs075 (reverse mvs075))
        (repeat (length mvs074)
          (setq mvs076 (member (car mvs074) mvs075))
            (if mvs076
              (progn
                (setq mvs077 (- (length mvs075) (length mvs076)))
                (setq mvs078 (cons (nth mvs077 mvs010) mvs078))
              )
            )
          (setq mvs074 (cdr mvs074))
        )
      (reverse mvs078)
    )
    (defun svm010 (mvs011 mvs012 / mvs079)
        (foreach elem mvs011
          (if (= (car elem) mvs012)
            (setq mvs079 (cons (cdr elem) mvs079))
          )
        )
      mvs079
    )
    (defun svm011 (mvs013 mvs014 / )
      (vl-catch-all-apply 'setvar (list mvs013 mvs014))
    )
    (defun svm012 ( / mvs080 mvs081 mvs082 mvs083 mvs084 mvs085 mvs086 mvs069)
      (setq mvs080 (list "AcDb2dPolyline" "AcDbArc" "AcDbCircle" "AcDbEllipse" "AcDbLine" "AcDbPolyline" "AcDbSpline"))
      (setq mvs081 (getvar "ERRNO"))
      (setq mvs082 T)
        (while mvs082
          (svm011 "ERRNO" 7)
            (while (= (getvar "ERRNO") 7)
              (svm011 "ERRNO" 0)
              (setq mvs083 (entsel "\nZu versetzendes Objekt whlen: "))
                (if (= (getvar "ERRNO") 7)
                  (princ "0 gefunden")
                )
            )
            (if mvs083
              (progn
                (if (not (vl-position mvs083 mvs205))
                  (progn
                    (setq mvs084 (svm010 (entget (car mvs083)) 100))
                    (setq mvs085 (cdr (assoc 8 (entget (car mvs083)))))
                      (if
                        (or 
                          (not(setq mvs086 (svm009 mvs084 mvs080)))
                          (and
                            mvs086
                            (not (svm007 (car mvs083)))
                          )
                          (= 4 (logand (cdr (assoc 70 (tblsearch "LAYER" mvs085))) 4))
                        )
                          (progn
                              (if (= 4 (logand (cdr (assoc 70 (tblsearch "LAYER" mvs085))) 4))
                                (princ "\nDas Objekt ist auf einem gesperrten Layer.")
                                (progn
                                  (if (not (svm009 mvs084 mvs080))
                                    (prompt "\nDieses Objekt kann mit ACM-MVERSETZEN nicht versetzt werden. ")
                                  )
                                )
                              )
                            (setq mvs084 nil mvs085 nil mvs082 T)
                          )
                          (setq mvs082 nil)
                      )
                    )
                    (setq mvs082 nil mvs206 T)
                  )
                )
              (setq mvs082 nil mvs069 nil)
            )
          (setq mvs069 nil)
        )
        (if mvs081
          (svm011 "ERRNO" mvs081)
        )
        (if mvs084
          (setq mvs069 (list (car mvs083) (car (svm009 mvs084 mvs080))))
        )
        (if mvs206
          (setq mvs069 (list mvs083 mvs083))
        )
        (if mvs069
          (setq mvs069 (car mvs069))
          mvs069
        )
        (if (= (type mvs069) 'ENAME)
          (redraw mvs069 3)
        )
      mvs069
    )
    (defun svm013 (mvs015 / mvs067)
      (setq mvs067 (fix mvs015))
        (if (= (type mvs067) 'INT)
          (itoa mvs067)
          (rtos mvs067 (getvar "LUNITS") 0)
        )
    )
    (defun svm014 ( / mvs088 mvs089)
        (if
          (not
            (and
              (= (type acm072023mversetzen1vorgabe) 'INT)
              (> acm072023mversetzen1vorgabe 0)
              (< acm072023mversetzen1vorgabe 1025)
            )
          )
            (setq acm072023mversetzen1vorgabe 1)
        )
      (setq mvs088 (getvar "PICKBOX"))
      (svm011 "PICKBOX" 0)
      (setq mvs089 (svm015 acm072023mversetzen1vorgabe "Anzahl der Versatzvorgnge eingeben" 1 1024))
        (if mvs088
          (svm011 "PICKBOX" mvs088)
        )
      (setq acm072023mversetzen1vorgabe mvs089)
      mvs089
    )
    (defun svm015 (mvs016 mvs017 mvs018 mvs019 / mvs069)
        (if (= "" (setq mvs069 (getstring (strcat "\n" mvs017 " <" (svm013 mvs016) ">: "))))
          (setq mvs069 (svm013 mvs016))
          (progn
            (while
              (or
                (not (svm016 mvs069))
                (< (atoi mvs069) mvs018)
                (> (atoi mvs069) mvs019)
              )
                (prompt (strcat "\nWert muss eine Ganzzahl zwischen " (svm013 mvs018) " und " (svm013 mvs019) " sein. "))
                  (if (= "" (setq mvs069 (getstring (strcat "\n" mvs017 " <" (svm013 mvs016) ">: "))))
                    (setq mvs069 (svm013 mvs016))
                  )
            )
          )
        )
      (atoi mvs069)
    )
    (defun svm016 (mvs020 / mvs090 mvs091)
      (setq mvs090 (svm018 (setq mvs020 (svm017 mvs020))))
        (if mvs090
          (setq mvs091 mvs020)
        )
        (while
          (and
            mvs090
            mvs091
          )
              (if (not (vl-position (car mvs090) '("0" "1" "2" "3" "4" "5" "6" "7" "8" "9")))
                (setq mvs091 nil)
              )
            (setq mvs090 (cdr mvs090))
        )
      mvs091
    )
    (defun svm017 (mvs021 / mvs026 mvs092 mvs093 mvs052)
      (setq mvs026 (strlen mvs021))
      (setq mvs092 (substr mvs021 1 1))
      (setq mvs093 0)
        (while
          (and
            (= mvs092 "\040")
            (/= mvs093 mvs026)
          )
            (setq mvs021 (substr mvs021 2))
            (setq mvs092 (substr mvs021 1 1))
            (setq mvs093 (+ mvs093 1))
        )
        (if (/= mvs093 mvs026)
          (progn
            (setq mvs026 (strlen mvs021))
            (setq mvs052 (substr mvs021 mvs026 1))
            (setq mvs093 mvs026)
              (while
                (and
                  (= mvs052 "\040")
                  (/= mvs093 0)
                )
                  (setq mvs021 (substr mvs021 1 mvs093))
                  (setq mvs052 (substr mvs021 mvs093 1))
                  (setq mvs093 (- mvs093 1))
              )
          )
        )
      mvs021
    )
    (defun svm018 (mvs022 / mvs093 mvs094)
        (if (= (type mvs022) 'STR)
          (progn
            (setq mvs093 1)
              (repeat (strlen mvs022)
                (setq mvs094 (cons (substr mvs022 mvs093 1) mvs094))
                (setq mvs093 (1+ mvs093))
              )
          )
        )
      (reverse mvs094)
    )
    (defun svm019 ( / mvs096)
        (if
          (not
            (and
              (vl-position (type acm072023mversetzen2vorgabe) (list 'INT 'REAL))
              (> acm072023mversetzen2vorgabe 0)
            )
          )
            (setq acm072023mversetzen2vorgabe 1.0)
        )
      (initget 6)
        (if (not (setq mvs096 (getdist (strcat "\nAbstand angeben <" (svm020 (rtos acm072023mversetzen2vorgabe 2)) ">: "))))
          (setq mvs096 acm072023mversetzen2vorgabe)
          (setq acm072023mversetzen2vorgabe mvs096)
        )
      mvs096
    )
    (defun svm020 (mvs023 / mvs097 mvs069)
        (if (= (type mvs023) 'STR)
          (progn
            (if (distof mvs023)
              (progn
                (setq mvs097 (getvar "DIMZIN"))
                (svm011 "DIMZIN" 8)
                (setq mvs023 (rtos (distof mvs023) 2 8))
                (setq mvs069 (rtos (distof mvs023 2) (getvar "LUNITS") (svm021 mvs023)))
                  (if mvs097
                    (svm011 "DIMZIN" mvs097)
                  )
                mvs069
              )
              nil
            )
          )
          nil
        )
    )
    (defun svm021 (mvs023 / mvs026 mvs097 mvs098)
      (setq mvs026 nil)
        (if (= (type mvs023) 'STR)
          (progn
            (setq mvs097 (getvar "DIMZIN"))
            (svm011 "DIMZIN" 8)
            (setq mvs023 (rtos (distof mvs023) 2 8))
              (if mvs097
                (svm011 "DIMZIN" mvs097)
              )
            (setq mvs098 (svm022 mvs023 "\056"))
              (if mvs098
                (setq mvs026 (- (strlen mvs023) mvs098))
                (setq mvs026 0)
              )
              (if (> mvs026 8)
                (setq mvs026 8)
              )
          )
        )
      mvs026
    )
    (defun svm022 (mvs022 mvs024 / mvs026 mvs099 mvs100 mvs101)
        (if
          (and
            (= (type mvs022) 'STR)
            (= (type mvs024) 'STR)
          )
            (progn
              (setq mvs026 (strlen mvs022))
              (setq mvs099 1)
                (while (<= mvs099 mvs026)
                  (setq mvs100 (substr mvs022 mvs099 1))
                    (if (/= mvs100 mvs024)
                      (progn
                        (setq mvs101 nil)
                        (setq mvs099 (1+ mvs099))
                      )
                    )
                    (if (= mvs100 mvs024)
                      (progn
                        (setq mvs101 mvs099)
                        (setq mvs099 (1+ mvs026))
                      )
                    )
                )
            )
            (setq mvs101 nil)
        )
      mvs101
    )
    (defun svm023 ( / mvs102 mvs204 mvs104)
      (setq mvs102 (vla-get-Layers (vla-get-ActiveDocument (vlax-get-acad-object))))
        (vlax-for mvs204 mvs102
          (if (not (vl-string-search "|" (setq mvs103 (vlax-get mvs204 'Name))))
            (setq mvs104 (cons mvs103 mvs104))
          )
        )
      (acad_strlsort mvs104)
    )
    (defun svm024 (mvs003 / mvs105 mvs106 mvs107 mvs108 mvs110 mvs079)
        (if (setq mvs105 (svm025))
          (progn
            (setq mvs106 (load_dialog mvs105))
              (if (not (new_dialog "moffset" mvs106))
                (exit)
              )
            (vl-catch-all-apply 'vl-file-delete (list mvs105))
            (setq mvs107 (svm023))
            (setq mvs108 (mapcar 'strcase mvs107))
              (if
                (or
                  (/= (type acm072023mversetzen3vorgabe) 'STR)
                  (and
                    (= (type acm072023mversetzen3vorgabe) 'STR)
                    (not (tblsearch "LAYER" acm072023mversetzen3vorgabe))
                  )
                )
                  (setq acm072023mversetzen3vorgabe (car mvs108))
              )
            (setq acm072023mversetzen3vorgabe (strcase acm072023mversetzen3vorgabe))
            (start_list "lb_01")
            (mapcar 'add_list mvs107)
            (end_list)
            (setq mvs110 (vl-position acm072023mversetzen3vorgabe mvs108))
            (set_tile "lb_01" (itoa mvs110))
            (action_tile "b_01" "(prompt (strcat \"\nLayer der versetzten Objekte = \" (svm001 (nth (atoi (get_tile \"lb_01\")) mvs107) 39) \" \")) (setq mvs079 (list 1 (setq acm072023mversetzen3vorgabe (nth (atoi (get_tile \"lb_01\")) mvs108)))) (done_dialog)")
            (action_tile "b_02" "(prompt (strcat \"\nLayer der versetzten Objekte = Von Quelle (\" (svm001 mvs003 39) \") \")) (setq mvs079 (list 0)) (done_dialog)")
            (start_dialog)
            (unload_dialog mvs106)
          )
        )
      mvs079
    )
    (defun svm025 ( / mvs111 mvs112 mvs113)
      (if
        (and
          (setq mvs111 (vl-filename-mktemp "acm.dcl"))
          (setq mvs112 (open mvs111 "w"))
        )
          (progn
            (setq mvs113
              (list
                "moffset"
                ":dialog{label=\042Layer whlen\042;"
                ":spacer{height=0;}"
                ":list_box{key=\042lb_01\042;height=10;allow_accept=true;}"
                ":spacer{height=0.3;}"
                ":row{"
                ":spacer{width=8;}"
                ":column{width=0;"
                ":button{key=\042b_01\042;label=\042Verwenden\042;is_default=true;}"
                ":button{key=\042b_02\042;label=\042Von Quelle\042;is_cancel=true;}}"
                ":spacer{width=8;}}}"
              )
            )
              (while mvs113
                (write-line (car mvs113) mvs112)
                (setq mvs113 (cdr mvs113))
              )
            (setq mvs112 (close mvs112))
            mvs111
          )
          nil
      )
    )
    (defun svm026 ( / mvs114)
      (setq mvs114 (strcase (getvar "PRODUCT")))
        (if
          (and
            (= mvs114 "AUTOCAD")
            (getvar "HPDRAWORDER")
          )
            (setq mvs079 T)
            (setq mvs079 nil)
        )
        (if (not mvs079)
          (alert "\042acm-mversetzen\042 kann nur unter AutoCAD ab Version 2005 verwendet werden.")
        )
      mvs079
    )
    (defun svm027 (mvs025 / )
        (if mvs116 (setq *error* mvs116))
        (if (= (type mvs034) 'ENAME)
          (vl-catch-all-apply 'redraw (list mvs034 4))
        )
        (if mvs030
          (vl-catch-all-apply 'setvar (list "CMDECHO" mvs030))
        )
        (if mvs031
          (vl-catch-all-apply 'setvar (list "OFFSETDIST" mvs031))
        )
        (if mvs088
          (vl-catch-all-apply 'setvar (list "PICKBOX" mvs088))
        )
        (if mvs097
          (vl-catch-all-apply 'setvar (list "DIMZIN" mvs097))
        )
      (vla-EndUndoMark (vla-get-ActiveDocument (vlax-get-acad-object)))
      (princ)
    )
  (if (svm026)
    (progn
      (vl-load-com)
      (setq mvs115 (vla-get-ActiveDocument (vlax-get-acad-object)))
      (setq mvs116 *error*)
      (setq *error* svm027)
      (vla-EndUndoMark mvs115)
      (vla-StartUndoMark mvs115)
      (svm002)
        (if mvs116
          (setq *error* mvs116)
          (setq *error* nil)
        )
      (vla-EndUndoMark mvs115)
    )
  )
  (princ)
)
(terpri)
(princ "\nAutoLISP-Tool ACM-MVERSETZEN (Copyright  2023 Gerhard Rampf) geladen.")
(princ "\nRufen Sie den Befehl mit ACM-MVERSETZEN auf.")
